tinymce.PluginManager.add("blockquote", function (editor) {
    function showDialog() {
        var selectedNode = editor.selection.getNode(),
            value = editor.dom.getParent(editor.selection.getNode()).innerHTML,
            footer = ''

        if (selectedNode.parentNode.nodeName.toLowerCase() === 'blockquote') {
            if (selectedNode.nextSibling !== null) {
                if (selectedNode.nextSibling.nodeName.toLowerCase() === 'footer') {
                    footer = selectedNode.nextSibling.innerHTML
                }
            }
            selectedNode = selectedNode.parentNode
        }

        editor.windowManager.open({
            title: "Blockquote",
            body: [{
                    label: 'Text',
                    type: "textbox",
                    name: "text",
                    multiline: !0,
                    minWidth: 600,
                    minHeight: 200,
                    value: value,
                    spellcheck: !1
                },
                {
                    label: 'Autor',
                    type: "textbox",
                    name: "byline",
                    multiline: 0,
                    value: footer,
                    spellcheck: !1
                }],
            onSubmit: function (e) {
                var output = '<blockquote class="small"><p>' + e.data.text + '</p><footer>' + e.data.byline + '</footer></blockquote>'
                editor.dom.remove(selectedNode)
                editor.selection.setContent(output)
            }
        })
    }
    editor.addButton("blockquote", {
        icon: "blockquote",
        tooltip: "Citát / autor",
        onclick: showDialog,
        stateSelector: 'blockquote'
    }),
    editor.addMenuItem("blockquote", {
        icon: "blockquote",
        text: "Citát / autor",
        context: "tools",
        onclick: showDialog
    })
});